#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;
using gov.va.med.vbecs.DAL.VistALink.Client;
using gov.va.med.vbecs.DAL.VAL;
#endregion

namespace gov.va.med.vbecs.VAL.UnitTests
{
	[TestFixture]
	public class VAL_VistALink : BaseTest 
	{
		private bool _vistALinkConnStateChangeHandlerFired = false;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			VistALinkUnitTestHarness.Touch();
			VistALink.Connect();
			VistALinkUnitTestHarness.TestUiBinder.CheckVistALinkReconnectIfNeeded_CallFlag = false;
			_vistALinkConnStateChangeHandlerFired = false;
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.TestUiBinder.CheckVistALinkReconnectIfNeeded_CallFlag = false;
			_vistALinkConnStateChangeHandlerFired = false;
		}

		[Test]
		public void Initialize_Binder_Pass()
		{
			try
			{
				VistALink.Connect();
			}
			finally
			{
				VistALinkUnitTestHarness.ReleaseConnection();
			}
			
			Assert.IsTrue(true);
		}

		[Test]
		[ExpectedException(typeof(InvalidOperationException))]
		public void Initialize_Binder_Fail()
		{
			// This call will always fail because VistAlink is already initialized in 
			// VistALinkUnitTestHarness static constructor
			VistALink.Initialize( new VistALinkUnitTestBinder(), null );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void Initialize_Binder_Fail2()
		{
			VistALink.Initialize( null, UnitTestConfig.VistAUserDuz );
		}

		[Test]
		public void Initialize_ConnInfo_Pass()
		{
			// This test repeats Initialize_1_Pass because it's the same initialization member called internally.
			try
			{
				VistALink.Connect();
			}
			finally
			{
				VistALinkUnitTestHarness.ReleaseConnection();
			}
			
			Assert.IsTrue(true);
		}

		[Test]
		[ExpectedException(typeof(InvalidOperationException))]
		public void Initialize_ConnInfo_Fail()
		{
			// This call will always fail because VistAlink is already initialized in 
			// VistALinkUnitTestHarness static constructor
			VistALink.Initialize( UnitTestConfig.VistAServerConnectionInfo, new VistALinkUnitTestBinder(), null );
		}

		[Test]
		public void Connect_Pass()
		{
			VistALinkUnitTestHarness.ForcedDisconnect();

			VistALink.Connect();

			Assert.IsTrue( VistALink.IsAvailable );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ParameterlessMethod ) ]
		public void Connect_Fail(){}


		[Test]
		public void Connect_2_Pass()
		{
			VistALinkUnitTestHarness.ForcedDisconnect();

			 Assert.IsTrue( VistALink.Connect( UnitTestConfig.VistAServerConnectionInfo ) );
		}

		[Test]
		public void Connect_2_Fail()
		{
			VistALinkUnitTestHarness.ForcedDisconnect();

			ServerConnectionInfo _validSci = UnitTestConfig.VistAServerConnectionInfo;
			ServerConnectionInfo _invalidSci = new ServerConnectionInfo( _validSci.IPAddress, _validSci.PortNumber + 1000 );
			
			Assert.IsTrue( !VistALink.Connect( _invalidSci ) );
		}

		[Test]
		public void ChangeDivision_Pass()
		{
			VistALinkUnitTestHarness.ForcedDisconnect();

			VistALink.ChangeDivision();

			Assert.IsTrue( !VistALink.IsAvailable );
		}

		[Test]
		public void ChangeDivision_Pass_2()
		{
			VistALinkUnitTestHarness.RequireConnection();

			VistALink.ChangeDivision();

			Assert.IsTrue( VistALink.IsAvailable );
		}

		[Test]
		public void Disconnect_Pass()
		{
			VistALinkUnitTestHarness.RequireConnection();

			VistALink.Disconnect();

			Assert.IsTrue( !VistALink.IsAvailable );
		}

		[Test]
		public void Disconnect_Fail()
		{
			VistALinkUnitTestHarness.ForcedDisconnect();

			VistALink.Disconnect();

			Assert.IsTrue( !VistALink.IsAvailable );
		}


		[Test]
		public void IsAvailable_Pass()
		{
			VistALinkUnitTestHarness.RequireConnection();

			Assert.IsTrue( VistALink.IsAvailable );
		}

		[Test]
		public void IsAvailable_Fail()
		{
			VistALinkUnitTestHarness.ForcedDisconnect();

			Assert.IsTrue( !VistALink.IsAvailable );
		}

		[Test]
		public void SetPrimaryServer_Pass_1()
		{
			try
			{
				VistALink.SetPrimaryServer( GetLocalStubConnectionInfo() );				

				VistALink.Connect(); 

				Assert.IsTrue( !VistALink.IsAvailable );
			}
			finally
			{
				VistALink.SetPrimaryServer( UnitTestConfig.VistAServerConnectionInfo );
			}			
		}

		[Test]
		public void SetPrimaryServer_Pass_2()
		{
			VistALinkUnitTestHarness.RequireConnection();

			Assert.IsTrue( VistALink.IsAvailable );

			VistALink.SetPrimaryServer( UnitTestConfig.VistAServerConnectionInfo );

			Assert.IsTrue( VistALink.IsAvailable );
		}

		[Test]
		public void SetPrimaryServer_Pass_3()
		{
			VistALinkUnitTestHarness.RequireConnection();

			Assert.IsTrue( VistALink.IsAvailable );
			
			try
			{
				VistALink.SetPrimaryServer( GetLocalStubConnectionInfo() );
			}
			finally
			{
				VistALink.SetPrimaryServer( UnitTestConfig.VistAServerConnectionInfo );
			}

			Assert.IsTrue( !VistALink.IsAvailable );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void SetPrimaryServer_Fail()
		{
			VistALink.SetPrimaryServer( null );
		}

		private ServerConnectionInfo GetLocalStubConnectionInfo()
		{
			return new ServerConnectionInfo( "127.0.0.1", 21991 );
		}

		[Test]
		public void EnsureAvailabilityWithoutFailureNotification_Pass_1()
		{
			VistALinkUnitTestHarness.ForcedDisconnect();

			Assert.IsTrue( VistALink.EnsureAvailabilityWithoutFailureNotification() );
			Assert.IsTrue( VistALinkUnitTestHarness.TestUiBinder.CheckVistALinkReconnectIfNeeded_CallFlag );
			Assert.IsTrue( VistALink.IsAvailable );
		}

		[Test]
		public void EnsureAvailabilityWithoutFailureNotification_Pass_2()
		{
			try
			{
				VistALink.SetPrimaryServer( GetLocalStubConnectionInfo() );

				Assert.IsTrue( !VistALink.EnsureAvailabilityWithoutFailureNotification() );
				Assert.IsTrue( VistALinkUnitTestHarness.TestUiBinder.CheckVistALinkReconnectIfNeeded_CallFlag );
			}
			finally
			{
				VistALink.SetPrimaryServer( UnitTestConfig.VistAServerConnectionInfo );
			}
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void EnsureAvailabilityWithoutFailureNotification_Fail() {}

		[Test]
		public void EnsureAvailability_Pass_1()
		{
			VistALinkUnitTestHarness.ForcedDisconnect();

			Assert.IsTrue( VistALink.EnsureAvailability() );
			Assert.IsTrue( VistALinkUnitTestHarness.TestUiBinder.CheckVistALinkReconnectIfNeeded_CallFlag );
			Assert.IsTrue( VistALink.IsAvailable );
		}

		[Test]
		public void EnsureAvailability_Pass_2()
		{
			try
			{
				VistALink.SetPrimaryServer( GetLocalStubConnectionInfo() );
				
				Assert.IsTrue( !VistALink.EnsureAvailability() );
			}
			finally
			{
				VistALink.SetPrimaryServer( UnitTestConfig.VistAServerConnectionInfo );
			}
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void EnsureAvailability_Fail() {}


		[Test]
		public void SilentCheckStatusReconnectIfNeeded_Pass_1()
		{
			VistALinkUnitTestHarness.ForcedDisconnect();

			Assert.IsTrue( VistALink.SilentCheckStatusReconnectIfNeeded() );
			Assert.IsTrue( !VistALinkUnitTestHarness.TestUiBinder.CheckVistALinkReconnectIfNeeded_CallFlag );
			Assert.IsTrue( VistALink.IsAvailable );

			// Try again, this time with an active connection to ensure all
			// code in SilentCheckStatusReconnectIfNeeded() is tested
			Assert.IsTrue( VistALink.SilentCheckStatusReconnectIfNeeded() );
		}

		[Test]
		public void SilentCheckStatusReconnectIfNeeded_Pass_2()
		{
			try
			{
				VistALink.SetPrimaryServer( GetLocalStubConnectionInfo() );

				Assert.IsTrue( !VistALink.SilentCheckStatusReconnectIfNeeded() );
				Assert.IsTrue( !VistALinkUnitTestHarness.TestUiBinder.CheckVistALinkReconnectIfNeeded_CallFlag );
			}
			finally
			{
				VistALink.SetPrimaryServer( UnitTestConfig.VistAServerConnectionInfo );
			}
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SilentCheckStatusReconnectIfNeeded_Fail() {}

		[Test]
		public void CheckStatus_Pass_1()
		{
			VistALinkUnitTestHarness.RequireConnection();
			Assert.IsTrue( VistALink.CheckStatus() );
		}

		[Test]
		public void CheckStatus_Pass_2()
		{
			VistALinkUnitTestHarness.ForcedDisconnect();
			Assert.IsTrue( !VistALink.CheckStatus() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CheckStatus_Fail() {}

		private void VistALinkConnectionStateChangedHandler( object sender, VistALinkConnectionStateChangedEventArgs e )
		{
			_vistALinkConnStateChangeHandlerFired = true;
		}

		[Test]
		public void ConnectionStateChanged_Pass_1()
		{
			VistALinkUnitTestHarness.ForcedDisconnect();
			VistALinkConnectionStateChangedDelegate _handler = new VistALinkConnectionStateChangedDelegate( VistALinkConnectionStateChangedHandler );

			try
			{
				VistALink.ConnectionStateChanged += _handler;

				VistALink.Connect();
				Assert.IsTrue( _vistALinkConnStateChangeHandlerFired );
			}
			finally
			{
				VistALink.ConnectionStateChanged -= _handler;
			}
		}

		[Test]
		public void ConnectionStateChanged_Pass_2()
		{
			VistALinkUnitTestHarness.ForcedDisconnect();
			VistALinkConnectionStateChangedDelegate _handler = new VistALinkConnectionStateChangedDelegate( VistALinkConnectionStateChangedHandler );

			try
			{
				VistALink.ConnectionStateChanged += _handler;
				VistALink.ConnectionStateChanged -= _handler;

				VistALink.Connect();

				Assert.IsTrue( !_vistALinkConnStateChangeHandlerFired );
			}
			finally
			{
				try
				{
					VistALink.ConnectionStateChanged -= _handler;
				}
				catch{} // removing handler just in case so it will error if handler is there (most likely). 
			}
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ConnectionStateChanged_Fail(){}
	}
}
#endif
